<?php
require('fpdf.php');

class PDF extends FPDF
{

    function Header()
    {
        $this->Ln(15);
    }

    // Page footer
    function Footer()
    {
        // Position at 1.5 cm from bottom
        $this->SetY(-15);
        // Arial italic 8
        $this->SetFont('Arial','I',8);
        // Page number
        $this->Cell(0,10,'Page '.$this->PageNo().'/{nb}',0,0,'C');
    }
}

$pdf = new PDF('L','mm','A4');
$pdf->AliasNbPages();

$pdf->AddPage();
$pdf->Image('images/header.png', 10, 10, 287);
$pdf->Ln(25);

$row_size_1 = 138;
$row_size_2 = 139;

$pdf->SetFont('Arial','B',9);

$y_len = $pdf->GetY();
$pdf->SetY($y_len);
$pdf->MultiCell($row_size_1,6, 'Facility Name & Address:M/s.Newgen Agro Processors Pvt Ltd., Krishnagiri. ', 1, 'L', 0);
$pdf->SetXY(10+$row_size_1,$y_len);
$pdf->MultiCell($row_size_2,6, 'Audited On: 05-05-2022', 1, 'L',0);


$y_len = $pdf->GetY();
$pdf->SetY($y_len);
$pdf->MultiCell($row_size_1,6, 'Audited By: A.MOHAMMED YOUNUS(PEX)', 1, 'L', 0);
$pdf->SetXY(10+$row_size_1,$y_len);
$pdf->MultiCell($row_size_2,6, '', 1, 'L',0);

$y_len = $pdf->GetY();
$pdf->SetY($y_len);
$pdf->MultiCell($row_size_1,6, 'Client Contact Person Name: Mr.Sudhagar (QM)', 1, 'L', 0);
$pdf->SetXY(10+$row_size_1,$y_len);
$pdf->MultiCell($row_size_2,6, 'PC Experts Contact Person Name: A.MOHAMMED YOUNUS', 1, 'L',0);

$y_len = $pdf->GetY();
$pdf->SetY($y_len);
$pdf->MultiCell($row_size_1,6, 'Client Contact Person No: .7373799008', 1, 'L', 0);
$pdf->SetXY(10+$row_size_1,$y_len);
$pdf->MultiCell($row_size_2,6, 'PC Experts Contact Person No: 9087200011', 1, 'L',0);

$pdf->SetFillColor(34, 9, 110);
$pdf->SetTextColor(255,255,255);

$y_len = $pdf->GetY();
$pdf->SetY($y_len);
$pdf->MultiCell($row_size_1+$row_size_2,8, 'FACILITY SURROUNDING', 1, 'C', 1);


$pdf->SetTextColor(0,0,0);

$y_len = $pdf->GetY();
$pdf->SetY($y_len);
$pdf->MultiCell($row_size_1+$row_size_2,8, 'In Our Audit your facility surrounded Thick Vegetation. Major thread for the surrounding is Flying insects, Rodents, Spiders, Snakes & Other Crawling insects.', 1, 'L', 0);


$row_1 = 10;
$row_2 = 51;
$row_3 = 78;
$row_4 = 78;
$row_5 = 30;
$row_6 = 30;

$pdf->SetFillColor(34, 9, 110);
$pdf->SetTextColor(255,255,255);

$pdf->SetFont('Arial','B',7);

$y_len = $pdf->GetY();
$pdf->SetY($y_len);
$pdf->MultiCell($row_1+$row_2+$row_3+$row_4,10, 'INTERAL PREMISES', 1, 'C', 1);
$pdf->SetXY($row_1+$row_2+$row_3+$row_4+10,$y_len);
$pdf->MultiCell($row_5,10, 'REVIEW DATE', 1, 'C', 1);
$pdf->SetXY($row_1+$row_2+$row_3+$row_4+$row_5+10,$y_len);
$pdf->MultiCell($row_6,10, 'COMPLETION DATE', 1, 'C', 1);

$pdf->SetTextColor(0,0,0);
$pdf->SetFont('Arial','B',8);

$table_height = 43;

for($i = 1;$i <= 11; $i++)
{
    $y_len = $pdf->GetY();

    if($y_len > 150)
    {
        $pdf->AddPage();
        $y_len = 25;
    }
    
    $temp_y = $testing_height = $y_len;
    if($temp_y > 180)
    {
        $temp_y = $testing_height = 25;
    }

    $pdf->SetXY($row_1+$row_2+$row_3+10,$y_len);
    $pdf->MultiCell($row_4,4, 'Hygiene Entrance', 1, 'L', 0);
    $dummy_y = $pdf->GetY();
    $cal_y = $dummy_y - $temp_y;
    $pdf->SetXY($row_1+$row_2+10,$temp_y);
    $pdf->MultiCell($row_3,$cal_y,'Location', 1, 'L', 0);

    $temp_y = $pdf->GetY();
    $pdf->SetXY($row_1+$row_2+$row_3+10,$temp_y);
    $pdf->MultiCell($row_4,4, 'Nil', 1, 'L', 0);
    $dummy_y = $pdf->GetY();
    $cal_y = $dummy_y - $temp_y;
    $pdf->SetXY($row_1+$row_2+10,$temp_y);
    $pdf->MultiCell($row_3,$cal_y, 'Cleaning / sanitation & Housekeeping Issues', 1, 'L', 0);

    $temp_y = $pdf->GetY();
    $pdf->SetXY($row_1+$row_2+$row_3+10,$temp_y);
    $pdf->MultiCell($row_4,4, 'PVC Strips & Air Velocity not Perfect Condition', 1, 'L', 0);
    $dummy_y = $pdf->GetY();
    $cal_y = $dummy_y - $temp_y;
    $pdf->SetXY($row_1+$row_2+10,$temp_y);
    $pdf->MultiCell($row_3,$cal_y, 'Structural Issue (Pest harbourages)', 1, 'L', 0);

    $temp_y = $pdf->GetY();
    $pdf->SetXY($row_1+$row_2+$row_3+10,$temp_y);
    $pdf->MultiCell($row_4,4, 'Nil', 1, 'L', 0);
    $dummy_y = $pdf->GetY();
    $cal_y = $dummy_y - $temp_y;
    $pdf->SetXY($row_1+$row_2+10,$temp_y);
    $pdf->MultiCell($row_3,$cal_y, 'Access Issues', 1, 'L', 0);

    $temp_y = $pdf->GetY();
    $pdf->SetXY($row_1+$row_2+$row_3+10,$temp_y);
    $pdf->MultiCell($row_4,4, 'Moth, Flies & crawling insects can hide & breed this area', 1, 'L', 0);
    $dummy_y = $pdf->GetY();
    $cal_y = $dummy_y - $temp_y;
    $pdf->SetXY($row_1+$row_2+10,$temp_y);
    $pdf->MultiCell($row_3,$cal_y, 'Description of Pest Infestation', 1, 'L', 0);

    $temp_y = $pdf->GetY();
    $pdf->SetXY($row_1+$row_2+$row_3+10,$temp_y);
    $pdf->MultiCell($row_4,4, 'nil', 1, 'L', 0);
    $dummy_y = $pdf->GetY();
    $cal_y = $dummy_y - $temp_y;
    $pdf->SetXY($row_1+$row_2+10,$temp_y);
    $pdf->MultiCell($row_3,$cal_y, 'Any other observations', 1, 'L', 0);

    $temp_y = $pdf->GetY();
    $pdf->SetXY($row_1+$row_2+$row_3+10,$temp_y);
    $pdf->MultiCell($row_4,4, 'PVC Strips will be replaced. Air Curtain will be Checked with Proper Air Velocity', 1, 'L', 0);
    $dummy_y = $pdf->GetY();
    $cal_y = $dummy_y - $temp_y;
    $pdf->SetXY($row_1+$row_2+10,$temp_y);
    $pdf->MultiCell($row_3,$cal_y, 'Preventive Action suggested to customer', 1, 'L', 0);

    $temp_y = $pdf->GetY();  
    $pdf->SetXY($row_1+$row_2+$row_3+10,$temp_y);
    $pdf->MultiCell($row_4,4, 'Instructed to technician Close monitoring required for this area.', 1, 'L', 0);
    $dummy_y = $pdf->GetY();
    $cal_y = $dummy_y - $temp_y;
    $pdf->SetXY($row_1+$row_2+10,$temp_y);
    $pdf->MultiCell($row_3,$cal_y, 'Curative action from', 1, 'L', 0);

    $total_height = $dummy_y - $testing_height;
    
    $pdf->SetXY($row_1+10,$testing_height);
    $pdf->Image('images/header.png', $row_1 + 10, $testing_height, $row_2, $total_height-2);
    $pdf->Rect($row_1+10,$testing_height,$row_2,$total_height);

    $pdf->SetY($testing_height);
    $pdf->MultiCell($row_1,$total_height, $i, 1, 'C', 0);

    $pdf->SetXY($row_1+$row_2+$row_3+$row_4+10,$testing_height);
    $pdf->MultiCell($row_5,$total_height, '12-05-2022', 1, 'C', 0);

    $pdf->SetXY($row_1+$row_2+$row_3+$row_4+$row_5+10,$testing_height);
    $pdf->MultiCell($row_6,$total_height, '30-06-2022', 1, 'C', 0);
}

$pdf->SetTextColor(209, 6, 6);
$pdf->SetFont('Arial','B',9);

$y_len = $pdf->GetY();
$pdf->SetY($y_len);
$pdf->MultiCell($row_size_1+$row_size_2,8, 'Note: In General your all window mesh will be replaced all windows. Also in Processing area. Fly Killer Machine will be placed to Fly Catcher Machines.', 1, 'C', 0);

$pdf->SetTextColor(0, 0, 0);

$y_len = $pdf->GetY();

if($y_len >160)
{
    $pdf->AddPage();
    $y_len = 25;
}

$first_height = $y_len;
$pdf->SetY($y_len);
$pdf->MultiCell($row_size_1,6, 'For Pest Control Experts', 0, 'L', 0);
$pdf->SetXY(10+$row_size_1,$y_len);
$pdf->MultiCell($row_size_2,6, 'For M/s.Newgen Agro Processors Pvt Ltd.,', 0, 'L',0);

$y_len = $pdf->GetY();
$pdf->SetY($y_len);
$pdf->MultiCell($row_size_1,6, 'Authorized Signature. ', 0, 'L', 0);
$pdf->SetXY(10+$row_size_1,$y_len);
$pdf->MultiCell($row_size_2,6, 'Authorized Signature.', 0, 'L',0);

$y_len = $pdf->GetY();
$pdf->SetY($y_len);
$pdf->MultiCell($row_size_1,6, 'Name: A.MOHAMMED YOUNUS', 0, 'L', 0);
$pdf->SetXY(10+$row_size_1,$y_len);
$pdf->MultiCell($row_size_2,6, 'Name:', 0, 'L',0);

$y_len = $pdf->GetY();
$pdf->SetY($y_len);
$pdf->MultiCell($row_size_1,6, 'Designation: MANAGER', 0, 'L', 0);
$pdf->SetXY(10+$row_size_1,$y_len);
$pdf->MultiCell($row_size_2,6, 'Designation:', 0, 'L',0);

$y_len = $pdf->GetY();
$pdf->SetY($y_len);
$pdf->MultiCell($row_size_1,6, 'Emp.Code. 002', 0, 'L', 0);
$pdf->SetXY(10+$row_size_1,$y_len);
$pdf->MultiCell($row_size_2,6, 'Emp.Code.', 0, 'L',0);

$y_len = $pdf->GetY();
$pdf->SetY($y_len);
$pdf->MultiCell($row_size_1,6, 'Phone Number: 9087200011', 0, 'L', 0);
$pdf->SetXY(10+$row_size_1,$y_len);
$pdf->MultiCell($row_size_2,6, 'Phone Number:', 0, 'L',0);

$last_height = $pdf->GetY();

$height_diff = $last_height - $first_height;
$pdf->Rect(10,$first_height,277,$height_diff);

$pdf->Output();
?>
